#if NUNIT
#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7AdtMessage
	{
		#region Variables & Setup

		private const string CARRIAGE_RETURN = "\x0D";

		private static string _hl7Message;

		HL7AdtMessage _adtMessage;

		static Messages_HL7AdtMessage()
		{
			_hl7Message = string.Concat(
				"MSH^~|\\&^VAFC PIMS^589^VBECS ADT^589^20110407120005-0500^^ADT~A08^5894298121^T^2.3^^^NE^NE^USA",
				CARRIAGE_RETURN,
				"EVN^A08^20110407^^^USER,ONE",
				CARRIAGE_RETURN,
				"PID^1^1000046604V343122^412730~4~M10^0701^USERALERTS~PATIENTONE^\"\"^19710101^F^^\"\"~~0005~\"\"~~CDC^\"\"~\"\"~\"\"~\"\"~\"\"~~P~\"\"~\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAE~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAA~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAC~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAM~\"\"~\"\"~~~\"\"&\"\"|\"\"~\"\"~\"\"~\"\"~\"\"~~VACAO~\"\"~\"\"~~~\"\"&\"\"^^\"\"^\"\"^^\"\"^29^^666000701^^^\"\"~~0189~\"\"~~CDC^",
				CARRIAGE_RETURN,
				"PD1^^^VA HEARTLAND - WEST, VISN 15~~589^\"\"",
				CARRIAGE_RETURN,
				"PV1^1^O^\"\"^^^^^^^^^^^^^^^ACTIVE DUTY^^^^^^^^^^^^^^^^^^^^^^^^^^20110407^^^^^^1307988",
				CARRIAGE_RETURN,
				"OBX^1",
				CARRIAGE_RETURN,
				"ZPD^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^0^\"\"^\"\"^\"\"^\"\"^0^\"\"^0^\"\"^\"\"^\"\"",
				CARRIAGE_RETURN,
				"ZSP^1^0^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^^\"\"",
				CARRIAGE_RETURN,
				"ZEL^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^0^ACTIVE DUTY^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"",
				CARRIAGE_RETURN,
				"ZCT^1^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"",
				CARRIAGE_RETURN,
				"ZEM^1^1^\"\"^\"\"^\"\"^\"\"^\"\"^\"\"",
				CARRIAGE_RETURN,
				"ZFF^2^.351;",
				CARRIAGE_RETURN,
				"ZIR^",
				CARRIAGE_RETURN,
				"ZEN^1",
				CARRIAGE_RETURN);
		}

		[SetUp]
		public void SetUp()
		{
			_adtMessage = new HL7AdtMessage( _hl7Message );
		}

		#endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7BtsMessage btsMessage = new HL7BtsMessage( _hl7Message );
			//
			Assert.IsTrue( btsMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7BtsMessage btsMessage = new HL7BtsMessage( null );
			//
			Assert.IsTrue( btsMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _adtMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

		[Test]
		public void GetMessageControlID_Pass()
		{
			Assert.IsNotNull( _adtMessage.GetMessageControlID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _adtMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsDemographicUpdate_Pass()
		{
			Assert.IsTrue( _adtMessage.IsDemographicUpdate() == true );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsDemographicUpdate_Fail()
		{
		}

		[Test]
		public void IsDischarge_Pass()
		{
			string hl7Message = string.Concat(
				"MSH^~|\\&^LRADT TRIGGER^589^VBECS ADT^^20090205143239-0500^^ADT~A03^5894325491^T^2.5^^^NE^AL^USA",
				CARRIAGE_RETURN,
				"EVN^A03^200902051432^^^10~USER~TEST",
				CARRIAGE_RETURN,
				"PID^1^1000055397V547770^412618^^VBPATIENT~SIXTY~SIZZ^^19450101^M^^^^^^^^^^^000000060^^^^^^^^^^",
				CARRIAGE_RETURN,
				"PV1^^I^6W GS-KC~C606D-1~~501~~~~~~589&VA HEARTLAND - WEST, VISN 15 (589)^^^^53342~USER~TEST",
				CARRIAGE_RETURN,
				"OBX^1^^WEIGHT^^55^CM",
				CARRIAGE_RETURN,
				"AL1^1^DOV^130~PENICILLIN~GMRD^SV^A|R^200901292043-0500",
				CARRIAGE_RETURN );
			//
			Assert.IsTrue( new HL7AdtMessage( hl7Message ).IsDischarge() == true );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsDischarge_Fail()
		{
		}

		[Test]
		public void isMessageTypeValid_Pass()
		{
			Assert.IsTrue( _adtMessage.IsMessageTypeValid() == true );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void isMessageTypeValid_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _adtMessage.IsResponseRequired() == true );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}

		#endregion

		#region Properties

		[Test]
		public void Delimiters_Pass()
		{
			Assert.IsNotNull( _adtMessage.Delimiters );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Delimiters_Fail()
		{
		}


		[Test]
		public void MessageType_Pass()
		{
			Assert.IsNotNull( _adtMessage.MessageType );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageType_Fail()
		{
		}
		
		[Test]
		public void TriggerEvent_Pass()
		{
			Assert.IsNotNull( _adtMessage.TriggerEvent );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TriggerEvent_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.IsNotNull( _adtMessage.Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

		[Test]
		public void MessageControlID_Pass()
		{
			Assert.IsNotNull( _adtMessage.MessageControlID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageControlID_Fail()
		{
		}

		[Test]
		public void MSH_Pass()
		{
			Assert.IsNotNull( _adtMessage.MSH );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSH_Fail()
		{
		}

		[Test]
		public void PID_Pass()
		{
			Assert.IsNotNull( _adtMessage.PID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PID_Fail()
		{
		}

		[Test]
		public void PV1_Pass()
		{
			Assert.IsNotNull( _adtMessage.PV1 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PV1_Fail()
		{
		}

		
		#endregion
	}
}
#endif